﻿# Cubism Native Samples

Live2D Cubism 3 Editorで出力したモデルを表示するアプリケーションのサンプル実装です。

Cubism Natve FrameworkおよびCubism Coreライブラリと組み合わせて使用します。


# フォルダ構成

- README.md  ...本ドキュメント
- Core       ...Cubism Coreライブラリが含まれるフォルダ
- Framework  ...レンダリングやアニメーション機能などのソースコードが含まれるフォルダ
- Samples    ...サンプルプロジェクトが含まれるフォルダ


# Cubism Native Framework

モデルを表示、操作するための各種機能を提供します。

[Cubism Native Framwork](https://github.com/Live2D/CubismNativeFramework)は、当リポジトリのサブモジュールとして含まれています。当リポジトリをクローンした後、サブモジュールのクローンを実行することでファイルが追加されます。


# Live2D Cubism Core for Native

モデルをロードするためのライブラリです。

当リポジトリにはLive2D Cubism Core for Nativeは同梱されていません。ダウンロードするには[こちら](https://live2d.github.io/)のページを参照ください。

ダウンロードしたZipファイルの中身を当リポジトリの/Coreディレクトリにコピーし、プログラムにリンクさせてください。


# ビルド方法

ビルド方法についてはサンプルプロジェクトによって異なります。各サンプルプロジェクトに同梱されたReadMeファイルを参照ください。


# コンパイルオプション

プロジェクトにおいて、マクロ `USE_RENDER_TARGET` または `USE_MODEL_RENDER_TARGET` が有効な場合、モデルがテクスチャへレンダリングされるようになります。

詳細はサンプルフォルダ内のLAppLive2DManager.cppを参照ください。


# SDKマニュアル

[Cubism SDK Manual](http://docs.live2d.com/cubism-sdk-manual/top/)


# 変更履歴

当リポジトリの変更履歴については[コミットログ](https://github.com/Live2D/CubismNativeSamples/commits/master)を参照ください。


# パッケージに関する変更

本SDKの beta12 にて一部の成果物に不備があったため、以下のファイルについて差し替えの対応を行いました。
* /Core/dll/*


# TODO

- 無し


# ライセンス
Cubism Native SamplesおよびCubism Native Framework は Live2D Open Software License で提供しています。
- Live2D Open Software License 
[日本語](http://www.live2d.com/eula/live2d-open-software-license-agreement_jp.html)
[English](http://www.live2d.com/eula/live2d-open-software-license-agreement_en.html)


Live2D Cubism Native Core は Live2D Proprietary Software License で提供しています。
 - Live2D Proprietary Software License 
[日本語](http://www.live2d.com/eula/live2d-proprietary-software-license-agreement_jp.html)
[English](http://www.live2d.com/eula/live2d-proprietary-software-license-agreement_en.html)


Live2D のサンプルモデルは Free Material License で提供しています。
- Free Material License 
[日本語](http://www.live2d.com/eula/live2d-free-material-license-agreement_jp.html)
[English](http://www.live2d.com/eula/live2d-free-material-license-agreement_en.html)
   - Samples/Res/Haru/*
   - Samples/Res/Hiyori/*
   - Samples/Res/Mark/*
   - Samples/Res/Natori/

上記のモデルをご利用になられる場合、[こちら](https://docs.live2d.com/cubism-editor-manual/sample-model/)で各モデルに設定された利用条件に同意して頂く必要がございます。

直近会計年度の売上高が 1000 万円以上の事業者様がご利用になる場合は、SDKリリース(出版許諾)ライセンスに同意していただく必要がございます。
- [SDKリリース(出版許諾)ライセンス](http://www.live2d.com/ja/products/releaselicense)


*All business* users must obtain a Publication License. "Business" means an entity  with the annual gross revenue more than ten million (10,000,000) JPY for the most recent fiscal year.
- [SDK Release (Publication) License](http://www.live2d.com/en/products/releaselicense)


